/*
 * Decompiled with CFR 0.152.
 */
package morph.avaritia.client.model;

import codechicken.lib.model.CachedFormat;
import codechicken.lib.model.Quad;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import morph.avaritia.client.model.HaloBakedModel;
import net.covers1624.quack.gson.JsonUtils;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.SimpleBakedModel;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.geometry.IModelGeometry;
import net.minecraftforge.client.model.pipeline.IVertexConsumer;

public class HaloItemModelLoader
implements IModelLoader<HaloItemModelGeometry> {
    public void m_6213_(ResourceManager p_10758_) {
    }

    public HaloItemModelGeometry read(JsonDeserializationContext deserializationContext, JsonObject modelContents) {
        JsonObject haloObj = modelContents.getAsJsonObject("halo");
        if (haloObj == null) {
            throw new IllegalStateException("Missing 'halo' object.");
        }
        IntArrayList layerColors = new IntArrayList();
        JsonArray layerColorsArr = modelContents.getAsJsonArray("layerColors");
        if (layerColorsArr != null) {
            for (JsonElement jsonElement : layerColorsArr) {
                layerColors.add(jsonElement.getAsInt());
            }
        }
        String texture = JsonUtils.getString((JsonObject)haloObj, (String)"texture");
        int color = JsonUtils.getInt((JsonObject)haloObj, (String)"color");
        int size = JsonUtils.getInt((JsonObject)haloObj, (String)"size");
        boolean pulse = JsonUtils.getAsPrimitive((JsonObject)haloObj, (String)"pulse").getAsBoolean();
        JsonObject clean = modelContents.deepCopy();
        clean.remove("halo");
        clean.remove("loader");
        BlockModel baseModel = (BlockModel)deserializationContext.deserialize((JsonElement)clean, BlockModel.class);
        return new HaloItemModelGeometry(baseModel, (IntList)layerColors, texture, color, size, pulse);
    }

    public static class HaloItemModelGeometry
    implements IModelGeometry<HaloItemModelGeometry> {
        private final BlockModel baseModel;
        private final IntList layerColors;
        private final String texture;
        private final int color;
        private final int size;
        private final boolean pulse;
        private Material haloMaterial;

        public HaloItemModelGeometry(BlockModel baseModel, IntList layerColors, String texture, int color, int size, boolean pulse) {
            this.baseModel = baseModel;
            this.layerColors = layerColors;
            this.texture = texture;
            this.color = color;
            this.size = size;
            this.pulse = pulse;
        }

        public BakedModel bake(IModelConfiguration owner, ModelBakery bakery, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelTransform, ItemOverrides overrides, ResourceLocation modelLocation) {
            BakedModel bakedBaseModel = this.baseModel.m_111449_(bakery, this.baseModel, spriteGetter, modelTransform, modelLocation, false);
            return new HaloBakedModel(HaloItemModelGeometry.tintLayers(bakedBaseModel, this.layerColors), spriteGetter.apply(this.haloMaterial), this.color, this.size, this.pulse);
        }

        public Collection<Material> getTextures(IModelConfiguration owner, Function<ResourceLocation, UnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
            HashSet<Material> materials = new HashSet<Material>();
            this.haloMaterial = owner.resolveTexture(this.texture);
            if (Objects.equals(this.haloMaterial.m_119203_(), MissingTextureAtlasSprite.m_118071_())) {
                missingTextureErrors.add((Pair<String, String>)Pair.of((Object)this.texture, (Object)owner.getModelName()));
            }
            materials.add(this.haloMaterial);
            materials.addAll(this.baseModel.m_5500_(modelGetter, missingTextureErrors));
            return materials;
        }

        private static BakedModel tintLayers(BakedModel model, IntList layerColors) {
            if (layerColors.isEmpty()) {
                return model;
            }
            HashMap<Direction, List<BakedQuad>> faceQuads = new HashMap<Direction, List<BakedQuad>>();
            for (Direction face : Direction.values()) {
                faceQuads.put(face, HaloItemModelGeometry.transformQuads(model.getQuads(null, face, new Random(), (IModelData)EmptyModelData.INSTANCE), layerColors));
            }
            List<BakedQuad> unculled = HaloItemModelGeometry.transformQuads(model.getQuads(null, null, new Random(), (IModelData)EmptyModelData.INSTANCE), layerColors);
            return new SimpleBakedModel(unculled, faceQuads, model.m_7541_(), model.m_7547_(), model.m_7539_(), model.m_6160_(), model.m_7442_(), ItemOverrides.f_111734_);
        }

        private static List<BakedQuad> transformQuads(List<BakedQuad> quads, IntList layerColors) {
            ArrayList<BakedQuad> newQuads = new ArrayList<BakedQuad>(quads.size());
            for (BakedQuad quad : quads) {
                newQuads.add(HaloItemModelGeometry.transformQuad(quad, layerColors));
            }
            return newQuads;
        }

        private static BakedQuad transformQuad(BakedQuad quad, IntList layerColors) {
            int tintIndex = quad.m_111305_();
            if (tintIndex == -1 || tintIndex >= layerColors.size()) {
                return quad;
            }
            int tint = layerColors.getInt(tintIndex);
            if (tint == -1) {
                return quad;
            }
            Quad newQuad = new Quad();
            newQuad.reset(CachedFormat.BLOCK);
            quad.pipe((IVertexConsumer)newQuad);
            float r = (float)(tint >> 16 & 0xFF) / 255.0f;
            float g = (float)(tint >> 8 & 0xFF) / 255.0f;
            float b = (float)(tint & 0xFF) / 255.0f;
            for (Quad.Vertex v : newQuad.vertices) {
                v.color[0] = v.color[0] * r;
                v.color[1] = v.color[1] * g;
                v.color[2] = v.color[2] * b;
            }
            newQuad.tintIndex = -1;
            return newQuad.bake();
        }
    }
}

